@rem --- Set this to the name of your world (ex. mars)
@set WORLDNAME=%1

@rem --- Some parameters for picaNew
@set DIRECTORY=worlds
@set RENDERSTART=1
@set RENDEREND=254

@echo off

rem --- Make sure the temporary files doesn't already exist
 del temp.pca

rem --- Write the parameters into the temporary file
 echo quantizeRGB() >> temp.pca
 echo outputPath(8bit) >> temp.pca
 echo paletteKey(6) >> temp.pca
 echo palOutputName(palettes\ipl\worlds\%WORLDNAME%-terrain.ipl) >> temp.pca
 echo chooseRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo extrudeMipLevels() >> temp.pca
 echo enforcePhoenixSave() >> temp.pca
 echo bitmapListStart() >> temp.pca
 echo 24bit\%DIRECTORY%\%WORLDNAME%*.bmp >> temp.pca

rem --- Begin conversion to Phoenix bitmap and output the new palette.
 picanew -v4 @temp.pca

rem --- Cleanup
 del temp.pca

rem --- Write the parameters into the temporary file
 echo quantizeRGB() >> temp.pca
 echo outputPath(8bit) >> temp.pca
 echo paletteKey(7) >> temp.pca
 echo palOutputName(palettes\ipl\worlds\%WORLDNAME%-skyd.ipl) >> temp.pca
 echo chooseRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo enforcePhoenixSave() >> temp.pca
 echo bitmapListStart() >> temp.pca
 echo 24bit\%DIRECTORY%\skies-day\%WORLDNAME%*.bmp >> temp.pca

rem --- Begin conversion to Phoenix bitmap and output the new palette.
 picanew -v4 @temp.pca

rem --- Cleanup
 del temp.pca

rem --- Write the parameters into the temporary file
 echo quantizeRGB() >> temp.pca
 echo outputPath(8bit) >> temp.pca
 echo paletteKey(7) >> temp.pca
 echo palOutputName(palettes\ipl\worlds\%WORLDNAME%-skyt.ipl) >> temp.pca
 echo chooseRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo enforcePhoenixSave() >> temp.pca
 echo bitmapListStart() >> temp.pca
 echo 24bit\%DIRECTORY%\skies-dusk\%WORLDNAME%*.bmp >> temp.pca

rem --- Begin conversion to Phoenix bitmap and output the new palette.
 picanew -v4 @temp.pca

rem --- Cleanup
 del temp.pca

rem --- Write the parameters into the temporary file
 echo quantizeRGB() >> temp.pca
 echo outputPath(8bit) >> temp.pca
 echo paletteKey(7) >> temp.pca
 echo palOutputName(palettes\ipl\worlds\%WORLDNAME%-skyn.ipl) >> temp.pca
 echo chooseRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo enforcePhoenixSave() >> temp.pca
 echo bitmapListStart() >> temp.pca
 echo 24bit\%DIRECTORY%\skies-night\%WORLDNAME%*.bmp >> temp.pca

rem --- Begin conversion to Phoenix bitmap and output the new palette.
 picanew -v4 @temp.pca

rem --- Cleanup
 del temp.pca